/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.animation;

import org.eclipse.swt.*;
import org.eclipse.swt.internal.wpf.*;
import org.eclipse.swt.widgets.*;

public class Animation {
	public static final int FOREVER = 0;
	
	static int count = 0;
	
	int handle, jniRef;
	long beginTime;
	boolean disposed;
	Widget widget;
	boolean autoReverse;
	int repeatCount = 1;
	
	void addChildren() {
	}
	
	void create () {
		handle = OS.gcnew_Storyboard();
		if (handle == 0) SWT.error(SWT.ERROR_NO_HANDLES);
		jniRef = OS.NewGlobalRef(this);
		if (jniRef == 0) SWT.error(SWT.ERROR_NO_HANDLES);
		OS.Timeline_AutoReverse(handle, autoReverse);
		int repeatBehavior;
		if (repeatCount == Animation.FOREVER) {
			repeatBehavior = OS.RepeatBehavior_Forever();
		} else {
			repeatBehavior = OS.gcnew_RepeatBehavior(repeatCount);
		}
		if (repeatBehavior == 0) SWT.error(SWT.ERROR_NO_HANDLES);
		OS.Timeline_RepeatBehavior(handle, repeatBehavior);
		OS.GCHandle_Free(repeatBehavior);
	}
	
	int createDotNetString (String string) {
		if (string == null) return 0;
		int length = string.length();
		char[] buffer = new char[length + 1];
		string.getChars(0, length, buffer, 0);
		int ptr = OS.gcnew_String(buffer);
		if (ptr == 0) SWT.error(SWT.ERROR_NO_HANDLES);
		return ptr;
	}
	
	void checkAnimation() {
		if (disposed) SWT.error(SWT.ERROR_WIDGET_DISPOSED);
		if (widget != null && widget.isDisposed()) SWT.error(SWT.ERROR_WIDGET_DISPOSED);
	}
	
	public void dispose() {
		if (disposed) return;
		disposed = true;
		release();
	}
	
//	public boolean getAutoReverse() {
//		checkAnimation();
//		return autoReverse;
//	}
	
	void release() {
		if (handle != 0) OS.GCHandle_Free(handle);
		handle = 0;
		if (jniRef != 0) OS.DeleteGlobalRef(jniRef);
		jniRef = 0;
	}
	
	public void start(Widget widget) {
		checkAnimation();
		setWidget(widget);
		create();
		addChildren();
		updateDuration(0);
		OS.Storyboard_Begin(handle, widget.handle, true);
	}
	
//	public void setAutoReverse(boolean autoReverse) {
//		checkAnimation();
//		this.autoReverse = autoReverse;
//	}
	
	public void setBeginTime(long beginTime) {
		checkAnimation();
		this.beginTime = beginTime;
	}

	public void setRepeatCount(int repeatCount) {
		checkAnimation();
		if (repeatCount == 0) SWT.error(SWT.ERROR_INVALID_ARGUMENT);
		this.repeatCount = repeatCount;
	}
	
	void setWidget(Widget widget) {
		this.widget = widget;
	}
	
	public void stop() {
		checkAnimation();
		if (widget != null) OS.Storyboard_Stop(handle, widget.handle);
	}
	
	long updateDuration(long delay) {
		return delay+beginTime;
	}
	
//	public void pause() {
//		checkAnimation();
//		if (widget != null) OS.Storyboard_Pause(handle, widget.handle);
//	}
	

//	public void resume() {
//		checkAnimation();
//		if (widget != null) OS.Storyboard_Resume(handle, widget.handle);
//	}
}
